gravityPatch = function(n_points, gravityPolarity, n_runs, matrixLength){
  
  x = runif(n = n_points)
  y = runif(n = n_points)
  
  if(n_runs != 0){
    for(i in 1:n_runs){
      distance = array(NA, dim = c((n_points - 1), n_points))
      angle = array(NA, dim = c((n_points - 1), n_points))
      force = array(0, dim = c((n_points - 1), n_points))
      for(i in 1:n_points){
        
        # Repeating boundary conditions
        xdiff = x[i] - x[-i]
        ydiff = y[i] - y[-i]
        xdiff[xdiff > 0.5] = xdiff[xdiff > 0.5] - 1
        ydiff[ydiff > 0.5] = ydiff[ydiff > 0.5] - 1
        xdiff[xdiff < -0.5] = xdiff[xdiff < -0.5] + 1
        ydiff[ydiff < -0.5] = ydiff[ydiff < -0.5] + 1
        
        distance[,i] = sqrt(abs(ydiff)^2 + abs(xdiff)^2)
        angle[,i] = atan2(ydiff, xdiff)
      }
      force = -gravityPolarity*(1/distance^2)*0.0001
      Fx = colSums(force*cos(angle))
      Fy = colSums(force*sin(angle))
      Fx[abs(Fx) > 0.01] = 0.01*sign(Fx[abs(Fx) > 0.01])
      Fy[abs(Fy) > 0.01] = 0.01*sign(Fy[abs(Fy) > 0.01])
      y = y + Fy
      x = x + Fx
      
      y = y %% 1
      x = x %% 1
    }
  }

  M = pointsToMatrix(x,y,matrixLength);sum(M)
  while(sum(M) < n_points){
    out = matrixToPoints(M)
    x = out[[1]]
    y = out[[2]]
    
    xi = runif(n = n_points - length(x))
    yi = runif(n = n_points - length(y))
    
    if(n_runs != 0){
      for(i in 1:n_runs){
        distance = array(NA, dim = c((length(x)), length(xi)))
        angle = array(NA, dim = c((length(x)), length(xi)))
        for(i in 1:length(xi)){
          distance[,i] = sqrt(abs(yi[i] - y)^2 + abs(xi[i] - x)^2)
          angle[,i] = atan2(y - yi[i], x - xi[i])
        }
        
        force = gravityPolarity*(1/distance^2)*0.00001
        Fx = colSums(force*cos(angle))
        Fy = colSums(force*sin(angle))
        Fx[abs(Fx) > 0.01] = 0.01*sign(Fx[abs(Fx) > 0.01])
        Fy[abs(Fy) > 0.01] = 0.01*sign(Fy[abs(Fy) > 0.01])
        yi = yi + Fy
        xi = xi + Fx
        
      }
    }
    x = c(x,xi)
    y = c(y,yi)
    M = pointsToMatrix(x,y,matrixLength)
  }  
  
  return(M)
}



